/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.NativeMemory;
import org.python.modules.jffi.Util;

class BoundedNativeMemory
implements Memory,
DirectMemory {
    protected static final MemoryIO IO = MemoryIO.getInstance();
    protected static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    final long address;
    final long size;
    final BoundedNativeMemory parent;

    BoundedNativeMemory(long l, int n) {
        this.address = l;
        this.size = n;
        this.parent = null;
    }

    private BoundedNativeMemory(BoundedNativeMemory boundedNativeMemory, long l) {
        this.address = boundedNativeMemory.address + l;
        this.size = boundedNativeMemory.size - l;
        this.parent = boundedNativeMemory;
    }

    private final void checkBounds(long l, long l2) {
        Util.checkBounds(this.size, l, l2);
    }

    public final long getAddress() {
        return this.address;
    }

    public BoundedNativeMemory slice(long l) {
        this.checkBounds(l, 1L);
        return l == 0L ? this : new BoundedNativeMemory(this, l);
    }

    public final boolean equals(Object object) {
        return object instanceof DirectMemory && ((DirectMemory)object).getAddress() == this.address;
    }

    public final int hashCode() {
        int n = 5;
        n = 53 * n + (int)(this.address ^ this.address >>> 32);
        return n;
    }

    public final boolean isNull() {
        return this.address == 0L;
    }

    public final boolean isDirect() {
        return true;
    }

    public final byte getByte(long l) {
        this.checkBounds(l, 1L);
        return IO.getByte(this.address + l);
    }

    public final short getShort(long l) {
        this.checkBounds(l, 2L);
        return IO.getShort(this.address + l);
    }

    public final int getInt(long l) {
        this.checkBounds(l, 4L);
        return IO.getInt(this.address + l);
    }

    public final long getLong(long l) {
        this.checkBounds(l, 8L);
        return IO.getLong(this.address + l);
    }

    public final long getNativeLong(long l) {
        return LONG_SIZE == 32 ? (long)this.getInt(l) : this.getLong(l);
    }

    public final float getFloat(long l) {
        this.checkBounds(l, 4L);
        return IO.getFloat(this.address + l);
    }

    public final double getDouble(long l) {
        this.checkBounds(l, 8L);
        return IO.getDouble(this.address + l);
    }

    public final long getAddress(long l) {
        this.checkBounds(l, ADDRESS_SIZE >> 3);
        return IO.getAddress(this.address + l);
    }

    public final DirectMemory getMemory(long l) {
        this.checkBounds(l, ADDRESS_SIZE >> 3);
        long l2 = IO.getAddress(this.address + l);
        return l2 != 0L ? new NativeMemory(l2) : null;
    }

    public final byte[] getZeroTerminatedByteArray(long l) {
        this.checkBounds(l, 1L);
        return IO.getZeroTerminatedByteArray(this.address + l, (int)(this.size - l));
    }

    public void putZeroTerminatedByteArray(long l, byte[] byArray, int n, int n2) {
        this.checkBounds(l, n2 + 1);
        IO.putZeroTerminatedByteArray(this.address + l, byArray, n, n2);
    }

    public final void putByte(long l, byte by) {
        this.checkBounds(l, 1L);
        IO.putByte(this.address + l, by);
    }

    public final void putShort(long l, short s) {
        this.checkBounds(l, 2L);
        IO.putShort(this.address + l, s);
    }

    public final void putInt(long l, int n) {
        this.checkBounds(l, 4L);
        IO.putInt(this.address + l, n);
    }

    public final void putLong(long l, long l2) {
        this.checkBounds(l, 8L);
        IO.putLong(this.address + l, l2);
    }

    public final void putNativeLong(long l, long l2) {
        if (LONG_SIZE == 32) {
            this.putInt(l, (int)l2);
        } else {
            this.putLong(l, l2);
        }
    }

    public final void putAddress(long l, long l2) {
        this.checkBounds(l, ADDRESS_SIZE >> 3);
        IO.putAddress(this.address + l, l2);
    }

    public final void putFloat(long l, float f) {
        this.checkBounds(l, 4L);
        IO.putFloat(this.address + l, f);
    }

    public final void putDouble(long l, double d) {
        this.checkBounds(l, 8L);
        IO.putDouble(this.address + l, d);
    }

    public final void putAddress(long l, Memory memory) {
        this.checkBounds(l, ADDRESS_SIZE >> 3);
        IO.putAddress(this.address + l, ((DirectMemory)memory).getAddress());
    }

    public final void get(long l, byte[] byArray, int n, int n2) {
        this.checkBounds(l, n2);
        IO.getByteArray(this.address + l, byArray, n, n2);
    }

    public final void put(long l, byte[] byArray, int n, int n2) {
        this.checkBounds(l, n2);
        IO.putByteArray(this.address + l, byArray, n, n2);
    }

    public final void get(long l, short[] sArray, int n, int n2) {
        this.checkBounds(l, n2 << 1);
        IO.getShortArray(this.address + l, sArray, n, n2);
    }

    public final void put(long l, short[] sArray, int n, int n2) {
        this.checkBounds(l, n2 << 1);
        IO.putShortArray(this.address + l, sArray, n, n2);
    }

    public final void get(long l, int[] nArray, int n, int n2) {
        this.checkBounds(l, n2 << 2);
        IO.getIntArray(this.address + l, nArray, n, n2);
    }

    public final void put(long l, int[] nArray, int n, int n2) {
        this.checkBounds(l, n2 << 2);
        IO.putIntArray(this.address + l, nArray, n, n2);
    }

    public final void get(long l, long[] lArray, int n, int n2) {
        this.checkBounds(l, n2 << 3);
        IO.getLongArray(this.address + l, lArray, n, n2);
    }

    public final void put(long l, long[] lArray, int n, int n2) {
        this.checkBounds(l, n2 << 3);
        IO.putLongArray(this.address + l, lArray, n, n2);
    }

    public final void get(long l, float[] fArray, int n, int n2) {
        this.checkBounds(l, n2 << 2);
        IO.getFloatArray(this.address + l, fArray, n, n2);
    }

    public final void put(long l, float[] fArray, int n, int n2) {
        this.checkBounds(l, n2 << 2);
        IO.putFloatArray(this.address + l, fArray, n, n2);
    }

    public final void get(long l, double[] dArray, int n, int n2) {
        this.checkBounds(l, n2 << 3);
        IO.getDoubleArray(this.address + l, dArray, n, n2);
    }

    public final void put(long l, double[] dArray, int n, int n2) {
        this.checkBounds(l, n2 << 3);
        IO.putDoubleArray(this.address + l, dArray, n, n2);
    }

    public final int indexOf(long l, byte by) {
        return by == 0 ? (int)IO.getStringLength(this.address + l) : (int)IO.indexOf(this.address + l, by);
    }

    public final int indexOf(long l, byte by, int n) {
        return (int)IO.indexOf(this.address, by, n);
    }

    public final void setMemory(long l, long l2, byte by) {
        this.checkBounds(l, l2);
        IO.setMemory(this.address + l, l2, by);
    }
}

